# QYbot 每日人品插件

每日人品插件是一个趣味性插件，可以为用户生成每日随机人品值（0-100），并根据人品值给出相应的趣味评论。

## 功能特性

- 每日随机生成人品值（0-100）
- 根据人品值提供趣味性毒舌评论
- 缓存机制：每个用户每天只会生成一次人品值
- 支持手动清除个人缓存
- 100种毒舌评论，覆盖各种人品情况

## 使用说明

### 1. 获取今日人品

```
@bot /今日人品
```

示例：

```
用户：@bot /今日人品
机器人：
你今天的人品是：88
发发？我看是罚罚
```

### 2. 删除缓存

如果想要重新生成今日人品值，可以使用删除缓存功能：

```
@bot /今日人品 删除缓存
```

示例：

```
用户：@bot /今日人品 删除缓存
机器人：已清除您今日的运势缓存

用户：@bot /今日人品
机器人：
你今天的人品是：75
七五计划倒霉版
```

## 评论示例

人品值与毒舌评论对应关系（部分示例）：

- 0: "系统都懒得给你编数据"
- 10: "水逆见了都自愧不如"
- 30: "平平无奇倒霉蛋"
- 50: "中庸得让人心疼"
- 66: "魔鬼的步伐666"
- 80: "欧皇体验卡到账"
- 90: "锦鲤本鲤出现了"
- 100: "建议检查系统漏洞"

## 注意事项

1. 每个用户每天只会生成一次人品值，重复查询会返回相同结果
2. 人品值在每天凌晨会自动重置
3. 可通过删除缓存功能手动重置当日人品值
4. 评论内容纯属娱乐，请勿当真

## 安装说明

1. 将插件文件夹放入 QYbot 的`/plugins`目录
2. 重启机器人或等待插件热重载
3. 在 QQ 机器人控制台添加指令：/今日人品

## 技术说明

### 缓存机制

插件使用本地 JSON 文件存储用户人品值缓存：

- 缓存文件路径：`cache.json`
- 缓存结构：以用户 openid 为键，存储人品值和时间戳
- 自动清理：每日自动清理过期缓存

### 评论系统

插件内置了 100 条毒舌评论，覆盖从 0 到 100 的所有人品值：

- 低人品（0-30）：以幽默方式描述倒霉情况
- 中等人品（31-70）：中性或略带调侃的评论
- 高人品（71-100）：正面或夸张的赞美评论

毒舌评论可自行在 `main.js` 中修改

## 错误处理

插件实现了完善的错误处理机制：

1. 缓存文件读写失败时会自动重建
2. 网络或系统异常时返回友好提示
3. 输入格式错误时提供正确使用示例
        