# QYbot 翻译插件

基于百度翻译 API 实现的 QQ 机器人翻译插件，支持多语言互译。

## 功能特性

- 支持中英日韩等 20+种语言互译
- 自动检测源语言
- 语言代码查询功能
- 智能错误处理

## 使用说明

### 1. 翻译指令

```
@bot 翻译 #目标语言代码 要翻译的文本
```

示例：

```
@bot 翻译 #en 你好世界
@bot 翻译 こんにちは
```

### 2. 语言代码查询

```
@bot 语言
```

### 3. 配置要求

在 config.js 中填写您的百度翻译 APPID 和 APPKEY

## 注意事项

1. 文本长度限制：2000 字符
2. 目标语言不能设置为"auto"
3. 未指定目标语言时默认翻译为中文

## 使用示例

1. 查询支持的语言：

```
用户：@bot 语言
机器人：
【常用语种对照表】
输入格式: @bot 翻译 #目标语言代码 要翻译的文本

中文    -> zh
英语    -> en
日语    -> jp
韩语    -> kor
...
```

2. 翻译到指定语言：

```
用户：@bot 翻译 #en 你好世界
机器人：Hello World
```

3. 自动翻译到中文：

```
用户：@bot 翻译 Hello World
机器人：你好世界
```

4. 无效语言代码：

```
用户：@bot 翻译 #xyz 你好
机器人：无法识别的语言代码: xyz，请使用"语言"指令获取常用语种代码
```

## 安装说明

1. 将插件文件夹放入 QYbot 的`/plugins`目录
2. 在`config.js`中填写百度翻译的 APPID 和 APPKEY
3. 重启机器人或等待插件热重载
4. 在 QQ 机器人控制台添加指令：翻译、语言

## 错误处理

插件实现了全面的错误处理机制：

1. API 调用失败时返回友好提示
2. 文本过长时提示限制
3. 无效语言代码时引导用户查询
4. 网络错误时自动重试

这个翻译插件完全遵循 QYbot 的插件开发规范，具有清晰的目录结构和完善的文档说明，可以无缝集成到 QYbot 系统中。
